/*  Esercizio: implementare una classe Pila che gestisce uno stack di numeri interi, e una classe Main che ne esegue il test.
    Una pila è una struttura dati che memorizza una lista di elementi, accessibili tramite la modalità LIFO (Last In First Out).
    Le operazioni che si possono fare su una pila sono 2:
     - inserimento di un elemento: viene inserito un nuovo elemento alla fine, cioè dopo l'ultimo elemento gia' presente,
     - rimozione di un elemento: viene rimosso l'ultimo elemento che è stato inserito nella pila.
    Un esempio di pila, è quando si mettono i piatti uno sopra l'altro: si può aggiungere un nuovo piatto solamente 
    mettendolo sopra l'ultimo, e si può togliere solo l'ultimo inserito.

    La classe Pila conterrà:
     - come attributo: un array di interi, per memorizzati i numeri interi,
     - metodi: push(int) che effettua l'inserimento di un intero in fondo alla pila, 
               pop() che rimuove, se presente, l'ultimo elemento inserito (cioè quello inserito più recentemente) e lo restituisce, 
               getNumElementi() che restituisce il numero di elementi presenti nella pila.
     - metodo opzionale: toString() che restituisce una stringa descrittiva contenente gli elementi dell'array
*/

public class Pila
{
    //array per memorizzare i dati
    int[] arr = new int[0];
    
    //metodo per inserire un nuovo elemento nella pila: quando si inserisce un elemento, si deve creare un nuovo array
    //di dimensione incrementata di 1, copiare il vecchio array e insierire nel'ultima posizione il nuovo elemento
    public void push(int val)
    {
        //si crea un array con una posizione in piu'
        int[] newArr = new int[arr.length +1];
        //si copia l'array nel nuovo array
        for(int i = 0; i < arr.length; i++)
            newArr[i] = arr[i];
        //l'ultimo elemento sara' quello in input
        newArr[newArr.length -1] = val;
        //si salva il nuovo array nella variabile di istanza, sostituendo l'array vecchio
        this.arr = newArr;
    }

    //metodo per rimuovere l'ultimo elemento della pila: quando si rimuove un elemento, si deve creare un nuovo array
    //di dimensione decrementata di 1, poi copiare il vecchio array ad eccezione l'elemento rimosso (cioè l'ultimo dell'array)
    public int pop()
    {
        //si controlla che l'array abbia almeno un elemento da rimuovere
        if(arr.length < 1)
            return -1;
        //si salva l'ultimo elemento, che sara' ritornato dalla funzione
        int val = arr[arr.length -1];
        //si crea un array con una posizione in meno
        int[] newArr = new int[arr.length -1];
        //si copia l'array nel nuovo array, tranne l'ultimo elemento
        for(int i = 0; i < newArr.length; i++)
            newArr[i] = arr[i];
        //si salva il nuovo array nella variabile di istanza, sostituendo l'array vecchio
        this.arr = newArr;
        //si restituisce l'elemento tolto
        return val;
    }
    
    //metodo che restituisce il numero di elementi
    public int getNumElementi()
    {
        return arr.length;
    }
    
    //metodo che restituisce una stringa contenente la lista degli elementi
    public String toString()
    {  
        String s = "{";
        if(arr.length > 0) {
            for(int i = 0; i < arr.length-1; i++)
                s += arr[i] + ", ";
            s += arr[arr.length-1];
        }
        s += "}";
        return s;
    }
}
